/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.utility.game;

import net.minecraft.class_3532;

public class ServerTpsUtility {
    private static float currentTPS = 20.0f;
    private static long lastUpdateTime = System.currentTimeMillis();

    public static void updateTPS(float tps) {
        currentTPS = class_3532.method_15363((float)tps, (float)0.1f, (float)20.0f);
        lastUpdateTime = System.currentTimeMillis();
    }

    public static float getCurrentTPS() {
        if (System.currentTimeMillis() - lastUpdateTime > 5000L) {
            return 20.0f;
        }
        return currentTPS;
    }

    public static long getAdjustedCooldown(long baseCooldown) {
        float tps = ServerTpsUtility.getCurrentTPS();
        if (tps >= 20.0f) {
            return baseCooldown;
        }
        float multiplier = 20.0f / tps;
        float additionalFactor = 1.0f + (20.0f - tps) * 0.05f;
        long adjusted = (long)((float)baseCooldown * multiplier * additionalFactor);
        return Math.min(adjusted, 3000L);
    }

    public static boolean canAttack(long lastAttackTime, long baseCooldown, long currentTime) {
        long adjustedCooldown = ServerTpsUtility.getAdjustedCooldown(baseCooldown);
        return currentTime >= lastAttackTime + adjustedCooldown;
    }

    public static boolean canAttack(long lastAttackTime, long baseCooldown) {
        return ServerTpsUtility.canAttack(lastAttackTime, baseCooldown, System.currentTimeMillis());
    }

    public static float getSpeedMultiplier() {
        float tps = ServerTpsUtility.getCurrentTPS();
        if (tps >= 20.0f) {
            return 1.0f;
        }
        return tps / 20.0f;
    }
}

